<?php include 'sayfalar/header.php'; ?>
<!DOCTYPE html>
<html lang="en">

<head>

    <?php $title = "İşletme Başvuruları";
    include 'partials/title-meta.php'; ?>

    <?php include 'partials/head-css.php'; ?>

</head>

<?php include 'partials/body.php'; ?>

<!-- Begin page -->
<div id="wrapper">

    <?php $pagetitle = "İşletme Başvuruları";
    include 'partials/menu.php'; ?>
    <!-- third party css -->
    <link href="assets/libs/datatables.net-bs5/css/dataTables.bootstrap5.min.css" rel="stylesheet" type="text/css" />
    <link href="assets/libs/datatables.net-responsive-bs5/css/responsive.bootstrap5.min.css" rel="stylesheet" type="text/css" />
    <link href="assets/libs/datatables.net-buttons-bs5/css/buttons.bootstrap5.min.css" rel="stylesheet" type="text/css" />
    <link href="assets/libs/datatables.net-select-bs5/css//select.bootstrap5.min.css" rel="stylesheet" type="text/css" />
    <!-- third party css end -->

    <!-- ============================================================== -->
    <!-- Start Page Content here -->
    <!-- ============================================================== -->
            <div class="content-page">
                <div class="content">

                    <!-- Start Content-->
                    <div class="container-fluid">
                        <div class="row">
                            <div class="col-12">
                                <div class="card">
                                    <div class="card-body">
                                        <h4 class="mt-0 header-title"><?php echo $pagetitle; ?> Listesi</h4>
                                        <p class="text-muted font-14 mb-3">
                                            İşletme Başvuruları listelenmektedir.
                                        </p>

                                        <table id="datatable-buttons" class="table table-striped table-bordered dt-responsive nowrap">
                                            <thead>
                                            <tr>
                                                <th>#</th>
                                                <th>İsim</th>
                                                <th width="10px">Tarih</th>
                                                <th width="19px">Kullanıcı</th>
                                                <th width="10px" align="center">Durum</th>
                                                <th>İşlem</th>
                                            </tr>
                                            </thead>


                                            <tbody>
                                            <?php

                                            $basvurusor=$db->prepare("SELECT * FROM isletmeler_basvuru order by id DESC");
                                            $basvurusor->execute();

                                            $say=0;
                                            while($basvurucek=$basvurusor->fetch(PDO::FETCH_ASSOC)) { $say++;
                                                $id=$basvurucek['kullanici'];
                                                $sahipsor=$db->prepare("SELECT * FROM kullanici where id=$id");
                                                $sahipsor->execute();
                                                $sahip=$sahipsor->fetch(PDO::FETCH_ASSOC);
                                                ?>
                                                <tr>
                                                    <td><a href="basvuru?goruntule=<?php echo $basvurucek['id']; ?>"><?php echo $say; ?></a></td>
                                                    <td><a href="basvuru?goruntule=<?php echo $basvurucek['id']; ?>"><?php echo $basvurucek['isim']; ?></a></td>
                                                    <td><a href="basvuru?goruntule=<?php echo $basvurucek['id']; ?>"><?php echo $basvurucek['tarih']; ?></a></td>
                                                    <td><a href="basvuru?goruntule=<?php echo $basvurucek['id']; ?>"><?php echo $sahip['ad']." ".$sahip['soyad']; ?></a></td>
                                                    <?php if ($basvurucek['durum']==1) { ?>
                                                        <td align="center"><a href="basvuru?goruntule=<?php echo $basvurucek['id']; ?>"><span class="badge bg-primary">Yeni Başvuru</span></a></td>
                                                    <?php } elseif ($basvurucek['durum']==2) { ?>
                                                        <td align="center"><a href="basvuru?goruntule=<?php echo $basvurucek['id']; ?>"><span class="badge bg-warning">İnceleme Sürecinde</span></a></td>
                                                    <?php } elseif ($basvurucek['durum']==3) { ?>
                                                        <td align="center"><a href="basvuru?goruntule=<?php echo $basvurucek['id']; ?>"><span class="badge bg-success">Onaylandı</span></a></td>
                                                    <?php } elseif ($basvurucek['durum']==0) { ?>
                                                        <td align="center"><a href="basvuru?goruntule=<?php echo $basvurucek['id']; ?>"><span class="badge bg-danger">Reddedildi</span></a></td>
                                                    <?php } else { ?>
                                                        <td align="center"><a href="basvuru?goruntule=<?php echo $basvurucek['id']; ?>"><span class="badge bg-danger">VERI GETIRILEMEDI</span></a></td>
                                                    <?php } ?>
                                                    <td align="center"> <a href="basvuru?goruntule=<?php echo $basvurucek['id']; ?>"><i class="fa fa-eye fa-4"></i></a></td>
                                                </tr>
                                            <?php } ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
                <?php include 'partials/footer.php'; ?>
            </div>

        <!-- ============================================================== -->
        <!-- End Page content -->
        <!-- ============================================================== -->


    </div>
    <!-- END wrapper -->

    <?php include 'partials/footer-scripts.php'; ?>
    <!-- third party js -->
    <script src="assets/libs/datatables.net/js/jquery.dataTables.min.js"></script>
    <script src="assets/libs/datatables.net-bs5/js/dataTables.bootstrap5.min.js"></script>
    <script src="assets/libs/datatables.net-responsive/js/dataTables.responsive.min.js"></script>
    <script src="assets/libs/datatables.net-responsive-bs5/js/responsive.bootstrap5.min.js"></script>
    <script src="assets/libs/datatables.net-buttons/js/dataTables.buttons.min.js"></script>
    <script src="assets/libs/datatables.net-buttons-bs5/js/buttons.bootstrap5.min.js"></script>
    <script src="assets/libs/datatables.net-buttons/js/buttons.html5.min.js"></script>
    <script src="assets/libs/datatables.net-buttons/js/buttons.flash.min.js"></script>
    <script src="assets/libs/datatables.net-buttons/js/buttons.print.min.js"></script>
    <script src="assets/libs/datatables.net-keytable/js/dataTables.keyTable.min.js"></script>
    <script src="assets/libs/datatables.net-select/js/dataTables.select.min.js"></script>
    <script src="assets/libs/pdfmake/build/pdfmake.min.js"></script>
    <script src="assets/libs/pdfmake/build/vfs_fonts.js"></script>
    <!-- third party js ends -->
    <script src="assets/js/pages/datatables.init.js"></script>
    <!-- App js-->
    <script src="assets/js/app.min.js"></script>


    </body>
</html>