<?php

ob_start();
session_start();
include 'baglan.php';
include '../../fonksiyon.php';
$ayarsor=$db->prepare("SELECT * FROM ayar where ayar_id=:id");
$ayarsor->execute(array(
  'id' => 0
));

$ayarcek=$ayarsor->fetch(PDO::FETCH_ASSOC);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $action = isset($_POST['action']) ? htmlspecialchars($_POST['action']) : null;
    switch ($action) {
        case 'make_reservation':
            $isim = isset($_POST['isim']) ? htmlspecialchars($_POST['isim']) : null;
            $telefon = isset($_POST['telefon']) ? htmlspecialchars($_POST['telefon']) : null;
            $kisi = isset($_POST['kisi']) ? htmlspecialchars($_POST['kisi']) : null;
            $tarih = isset($_POST['tarih']) ? htmlspecialchars($_POST['tarih']) : null;
            $isletme = isset($_POST['isletme']) ? htmlspecialchars($_POST['isletme']) : null;
            $oda = isset($_POST['oda']) ? htmlspecialchars($_POST['oda']) : null;
            $digertarih = isset($_POST['digertarih']) ? htmlspecialchars($_POST['digertarih']) : null;
            if (!$isim || !$telefon || !$kisi || !$tarih || ($tarih === 'other' && !$digertarih)) {
                echo json_encode(['status' => 'error', 'message' => 'Lütfen tüm alanları doldurun.']);
                exit;
            }

            if ($tarih === 'other') {
                $tarih = $digertarih;
            } else {
                switch ($tarih) {
                    case 'today':
                        $tarih = date('Y-m-d');
                        break;
                    case 'tomorrow':
                        $tarih = date('Y-m-d', strtotime('+1 day'));
                        break;
                    case 'nextDay':
                        $tarih = date('Y-m-d', strtotime('+2 days'));
                        break;
                    default:
                        echo json_encode(['status' => 'error', 'message' => 'Geçersiz tarih seçeneği.']);
                        exit;
                }
            }
            $zamanDamgasi = strtotime($tarih);
            $tarihFormatli = date('d.m.Y', $zamanDamgasi);
            try {
                $stmt = $db->prepare("INSERT INTO rezervasyon (isim, telefon, kisi, tarih, isletme, oda) VALUES (:isim, :telefon, :kisi, :tarih, :isletme, :oda)");
                $stmt->bindParam(':isim', $isim);
                $stmt->bindParam(':telefon', $telefon);
                $stmt->bindParam(':kisi', $kisi);
                $stmt->bindParam(':tarih', $tarih);
                $stmt->bindParam(':isletme', $isletme);
                $stmt->bindParam(':oda', $oda);
                $stmt->execute();

                $sql = "SELECT email FROM kullanici WHERE isletme=$isletme";
                $isletmebilgisi = $db->prepare($sql);
                $isletmebilgisi->execute();

                $recipientEmails = $isletmebilgisi->fetchAll(PDO::FETCH_COLUMN);
                $nereye = implode(',', $recipientEmails);

                // Örnek emailgonder fonksiyonu
                emailgonder(
                    '', // BCC için e-posta adresleri, boş bırakabilirsiniz
                    $nereye, // Alıcıların e-posta adresleri
                    'DENEME', // İsim
                    'Rezervasyon talebi alındı.', // Konu
                    "<span class='text-center'>Bilgiler:</span> <br>İsim: $isim<br>Telefon: $telefon<br>Kişi Sayısı: $kisi kişi<br>Tarih: $tarihFormatli" // Mesaj
                );
                echo json_encode(['status' => 'success', 'message' => 'Rezervasyon başarıyla eklendi.']);
            } catch (PDOException $e) {
                echo json_encode(['status' => 'error', 'message' => 'Veritabanı hatası: ' . $e->getMessage()]);
            }
            break;

        case 'make_bulten':
            $eposta=$_POST['mail'];
            $bultenvarmisor=$db->prepare("SELECT * FROM ebulten WHERE mail=:mail");
            $bultenvarmisor->execute(array(
              'mail' => $eposta
            ));
            $bultenvarmi=$bultenvarmisor->rowCount();
            if ($bultenvarmi==0){
                $stmt = $db->prepare("INSERT INTO ebulten (mail) VALUES (:mail)");
                $stmt->bindParam(':mail', $eposta);
                $stmt->execute();
                echo json_encode(['status' => 'success', 'message' => 'E-Bülten kaydınız yapıldı.']);
                break;
            }
            else {
                echo json_encode(['status' => 'error', 'message' => 'Bu E-Posta adresi zaten kayıtlı.']);
                break;
            }

        default:
            echo json_encode(['status' => 'error', 'message' => 'Geçersiz işlem türü.']);
            break;
    }
} else {
    echo json_encode(['status' => 'error', 'message' => 'Geçersiz istek yöntemi.']);
}
?>