<?php
// Veritabanı bağlantısı ve diğer gerekli işlemleri yapın
require_once("baglan.php"); // Veritabanı bağlantınızı sağlayan dosya

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Ajax ile gönderilen verileri alın
    $title = $_POST["title"];
    $start = $_POST["start"];
    $end = $_POST["end"];
    $description = $_POST["description"];
    $plaka = $_POST["plaka"];

    $musteri = $_POST["selectedCustomerId"];

    // Veritabanına etkinliği ekleyin
    $query = $db->prepare("INSERT INTO randevu (title, start, end, description, plaka, musteri) VALUES (:title, :start, :end, :description, :plaka, :musteri)");
    $query->bindParam(":title", $title, PDO::PARAM_STR);
    $query->bindParam(":start", $start, PDO::PARAM_STR); // Kolon tipine bağlı olarak PDO::PARAM_STR veya PDO::PARAM_INT olarak değiştirin
    $query->bindParam(":end", $end, PDO::PARAM_STR);     // Kolon tipine bağlı olarak PDO::PARAM_STR veya PDO::PARAM_INT olarak değiştirin
    $query->bindParam(":description", $description, PDO::PARAM_STR);
    $query->bindParam(":plaka", $plaka, PDO::PARAM_STR);
    $query->bindParam(":musteri", $musteri, PDO::PARAM_STR);

    if ($query->execute()) {
        echo json_encode(["status" => "success", "message" => "Etkinlik başarıyla eklendi". $musteri]);
    } else {
        echo json_encode(["status" => "error", "message" => "Etkinlik eklenirken bir hata oluştu" .$plaka .$musteri]);
    }
} else {
    echo json_encode(["status" => "error", "message" => "Geçersiz istek"]);
}
?>