<?php
// ajax.php

// Veritabanı bağlantısı ve etkinlikleri getirme işlemleri
require_once("baglan.php"); // Veritabanı bağlantınızı sağlayan dosya

$eventId = isset($_POST['eventId']) ? $_POST['eventId'] : null;

// Eğer etkinlik ID geçerli ise, etkinliği sil
if ($eventId) {
    // Etkinliği silme sorgusu
    $sql = "DELETE FROM randevu WHERE id = :eventId";

    // Hazırlanan ifadeyi oluştur
    $stmt = $db->prepare($sql);

    // Parametreleri bağla
    $stmt->bindParam(':eventId', $eventId, PDO::PARAM_INT);

    // Sorguyu çalıştır
    if ($stmt->execute()) {
        // Silme işlemi başarılı ise JSON yanıtı gönder
        $response = array('status' => 'success', 'message' => 'Etkinlik başarıyla silindi.');
    } else {
        // Silme işlemi başarısız ise JSON yanıtı gönder
        $response = array('status' => 'error', 'message' => 'Etkinlik silinirken bir hata oluştu.');
    }

    // İfadeleri kapat
    $stmt->closeCursor();
} else {
    // Geçersiz etkinlik ID'si durumunda hata yanıtı gönder
    $response = array('status' => 'error', 'message' => 'Geçersiz etkinlik ID.'. $eventId);
}

// JSON formatında yanıtı döndür
echo json_encode($response);
?>