<?php
include 'baglan.php';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $message = trim($_POST['message']);
    $username = 'User';  // Kullanıcı adı burada dinamik olarak alınabilir

    if (empty($message)) {
        echo json_encode(['status' => 'error', 'message' => 'Message cannot be empty.']);
        exit;
    }

    try {
        $stmt = $db->prepare("INSERT INTO messages (username, message) VALUES (:username, :message)");
        $stmt->execute(['username' => $username, 'message' => htmlspecialchars($message)]);

        echo json_encode(['status' => 'success', 'message' => 'Message sent successfully!']);
    } catch (PDOException $e) {
        echo json_encode(['status' => 'error', 'message' => 'Failed to send message: ' . $e->getMessage()]);
    }
}
?>
