<?php
ob_start();
session_start();
include 'baglan.php';
include '../../fonksiyon.php';
header('Content-Type: text/html; charset=UTF-8');
$ayarsor=$db->prepare("SELECT * FROM ayar where ayar_id=:id");
$ayarsor->execute(array(
  'id' => 0
));

$ayarcek=$ayarsor->fetch(PDO::FETCH_ASSOC);
// HTTP isteğinin yalnızca POST olmasını sağla
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Gelen JSON verisini al
    $data = json_decode(file_get_contents("php://input"), true);

    // İşlem parametresini kontrol et
    if (isset($data['islem'])) {
        $islem = $data['islem'];

        switch ($islem) {
            case 'yorumyap':
                // Verileri al
                $name = $data['name'];
                $email = $data['email'];
                $oda = $data['oda'];
                $message = $data['message'];
                $saveInfo = $data['saveInfo'];
                $kaliteStars = $data['kaliteStars'];
                $fiyatStars = $data['fiyatStars'];
                $lokasyonStars = $data['lokasyonStars'];
                $isletme = $data['isletme'];
                $puan = ($fiyatStars + $kaliteStars + $lokasyonStars) / 3;
                $number = $puan;
                $puan = round($number, 1);
                $tarih = date('d.m.Y');

                try {
                    // Veritabanına kaydet (örnek SQL sorgusu)
                    $sql = "INSERT INTO yorumlar (sahip, email, yorum, puan, izin, kalite, tarih, oda, fiyat, lokasyon, isletme) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
                    $stmt = $db->prepare($sql);
                    $stmt->execute([$name, $email, $message, $puan, $saveInfo, $kaliteStars, $tarih, $oda, $fiyatStars, $lokasyonStars, $isletme]);

                    $response = array('success' => true);
                } catch (PDOException $e) {
                    $response = array('success' => false, 'message' => 'Veritabanına eklenirken hata oluştu: ' . $e->getMessage());
                }

                break;

            // Diğer işlemler burada eklenebilir

            default:
                // Bilinmeyen işlem için hata yanıtı döndür
                $response = array('success' => false, 'message' => 'Geçersiz işlem.');
                break;
        }
    } else {
        // İşlem parametresi yoksa hata döndür
        $response = array('success' => false, 'message' => 'İşlem parametresi eksik.');
    }

    // JSON yanıtı döndür
    header('Content-Type: application/json');
    echo json_encode($response);
} else {
    // Yanlış istek yöntemi için hata döndür
    header('HTTP/1.1 405 Method Not Allowed');
    echo "Yalnızca POST istekleri kabul edilir.";
}
?>
