<?php include 'sayfalar/header.php'; ?>
<!DOCTYPE html>
<html lang="en">

<head>

    <?php $title = "İşletme";
    include 'partials/title-meta.php'; ?>
    <!-- Plugins css -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="ckeditor/build/ckeditor.js"></script>
    <link href="assets/libs/mohithg-switchery/switchery.min.css" rel="stylesheet" type="text/css" />
    <link href="assets/libs/multiselect/css/multi-select.css" rel="stylesheet" type="text/css" />
    <link href="assets/libs/select2/css/select2.min.css" rel="stylesheet" type="text/css" />
    <link href="assets/libs/selectize/css/selectize.bootstrap3.css" rel="stylesheet" type="text/css" />
    <link href="assets/libs/bootstrap-touchspin/jquery.bootstrap-touchspin.min.css" rel="stylesheet" type="text/css" />
    <link href="assets/libs/toastr/build/toastr.min.css" rel="stylesheet" type="text/css" />
    <link href="assets/libs/dropzone/min/dropzone.min.css" rel="stylesheet" type="text/css" />
    <link href="assets/libs/dropify/css/dropify.min.css" rel="stylesheet" type="text/css" />
    <?php include 'partials/head-css.php'; ?>


</head>
<style>
        /* CKEditor kapsayıcı öğesi için stil */
        .ck-editor__editable_inline {
            min-height: 300px; /* Yüksekliği ayarlayın */
            width: 100%; /* Genişliği ayarlayın */
        }

    .image-container {
        position: relative;
        display: inline-block;
    }

    .delete-overlay {
        position: absolute;
        top: 50%;
        left: 50%;
        transform: translate(-50%, -50%);
        background-color: rgba(255, 0, 0, 0.7);
        color: white;
        padding: 10px;
        box-sizing: border-box;
        opacity: 0;
        text-align: center;
        line-height: 1.5;
        cursor: pointer;
        transition: opacity 0.3s;
    }

    .image-container:hover .delete-overlay {
        opacity: 1;
    }
</style>
<?php include 'partials/body.php'; ?>

<!-- Begin page -->
<div id="wrapper">

    <?php $pagetitle = "İşletme";
    include 'partials/menu.php'; ?>
    <!-- third party css -->

    <!-- third party css end -->

    <!-- ============================================================== -->
    <!-- Start Page Content here -->
    <!-- ============================================================== -->
    <?php

        $isletmesor=$db->prepare("SELECT * FROM isletmeler where id=:id");
        $isletmesor->execute(array(
            'id' => $isletme['id']
        ));
        $isletme=$isletmesor->fetch(PDO::FETCH_ASSOC);

        ?>

        <div class="content-page">
            <div class="content">

                <!-- Start Content-->
                <div class="container-fluid">


                <div class="row">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-body">
                                    <h4 class="header-title">İşletme Ayarları</h4>
                                    <p class="text-muted font-13"></p>

                                    <form id="myForm">
                                        <div class="row">
                                            <div class="col-md-3 mb-3">
                                                <label class="form-label">İşletme İsmi</label>
                                                <input type="text" id="isim" class="form-control" name="isim" required value="<?php echo $isletme['isim']; ?>">
                                            </div>
                                            <div class="col-md-5 mb-3">
                                                <label class="form-label">İşletme Ünvanı</label>
                                                <input type="text" id="unvan" class="form-control" name="unvan" required value="<?php echo $isletme['unvan']; ?>">
                                            </div>
                                            <div class="col-md-2 mb-3">
                                                <label class="form-label">İşletme Telefonu</label>
                                                <input type="text" id="telefon" class="form-control" name="telefon" required value="<?php echo $isletme['telefon']; ?>" disabled>
                                            </div>
                                            <div class="col-md-2 mb-3">
                                                <label class="form-label">İşletme Sahibi</label>
                                                <select class="form-control" data-toggle="select2" id="sahip" name="sahip" data-width="100%" required disabled>
                                                    <optgroup label="Kullanıcılar">
                                                        <?php

                                                        $sahipsor=$db->prepare("SELECT * FROM kullanici where (isletme=:isletme or isletme=:varolan) order by id DESC");
                                                        $sahipsor->execute(array(
                                                            'isletme' => 0,
                                                            'varolan' => $isletme['id']
                                                            ));

                                                        while($sahipcek=$sahipsor->fetch(PDO::FETCH_ASSOC)) { ;

                                                            ?>
                                                            <option <?php echo ($sahipcek['id']==$isletme['sahip']) ? 'selected' : ''; ?> value="<?php echo $sahipcek['id']; ?>"><?php echo $sahipcek['ad']. " " .$sahipcek['soyad']; ?></option>
                                                        <?php } ?>
                                                    </optgroup>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-md-3 mb-3">
                                                <label class="form-label">Vergi Dairesi</label>
                                                <input class="form-control" id="vergidaire" type="text" name="vergidaire" required value="<?php echo $isletme['vergidaire']; ?>">
                                            </div>
                                            <div class="col-md-3 mb-3">
                                                <label class="form-label">Vergi No</label>
                                                <input class="form-control" id="vergino" type="text" name="vergino" required value="<?php echo $isletme['vergino']; ?>">
                                            </div>

                                            <script>
                                                document.getElementById('vergino').addEventListener('input', function (e) {
                                                    // Girilen değeri sadece rakamlarla sınırla
                                                    this.value = this.value.replace(/\D/g, '');
                                                });
                                            </script>
                                            <div class="col-md-2 mb-3">
                                                <label class="form-label">Kategori</label>
                                                <select class="form-control" data-toggle="select2" id="kategori" name="kategori" data-width="100%" required>
                                                    <optgroup label="İşletme Kategorileri">
                                                        <?php

                                                        $kategorisor=$db->prepare("SELECT * FROM isletmeler_kategori order by id ASC");
                                                        $kategorisor->execute();

                                                        while($kategoricek=$kategorisor->fetch(PDO::FETCH_ASSOC)) { ;

                                                            ?>
                                                            <option <?php echo ($kategoricek['id']==$isletme['kategori']) ? 'selected' : ''; ?> value="<?php echo $kategoricek['id']; ?>"><?php echo $kategoricek['isim']; ?></option>
                                                        <?php } ?>
                                                    </optgroup>
                                                </select>
                                            </div>
                                            <div class="col-md-2 mb-3">
                                                <label class="form-label">İl</label>
                                                <select class="form-control" id="il" name="il" data-width="100%" required>
                                                    <option value="">İl Seçiniz</option>
                                                    <?php

                                                    $selectedIlId = $isletme['il'];
                                                    $selectedIlceId = $isletme['ilce'];

                                                    // Tüm il seçeneklerini veri tabanından çekelim
                                                    $ilsor = $db->prepare("SELECT * FROM il ORDER BY id ASC");
                                                    $ilsor->execute();
                                                    $ilList = $ilsor->fetchAll(PDO::FETCH_ASSOC);

                                                    foreach ($ilList as $il) {
                                                        echo '<option value="' . $il['id'] . '"' . ($il['id'] == $selectedIlId ? ' selected' : '') . '>' . $il['isim'] . '</option>';
                                                    }
                                                    ?>
                                                </select>
                                            </div>
                                            <div class="col-md-2 mb-3">
                                                <label class="form-label">İlçe</label>
                                                <select class="form-control" id="ilce" name="ilce" data-width="100%" required>
                                                    <option value="">İlçe Seçiniz</option>
                                                    <!-- İlçe seçenekleri AJAX ile yüklenecek -->
                                                </select>
                                            </div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    var ilSelect = document.getElementById('il');
    var ilceSelect = document.getElementById('ilce');

    function loadIlceler(ilID, selectedIlceID = null) {
        if (ilID) {
            ilceSelect.disabled = false;

            var xhr = new XMLHttpRequest();
            xhr.open('GET', 'netting/ilce_getir.php?il_id=' + ilID, true);
            xhr.setRequestHeader('Content-Type', 'application/json');

            xhr.onreadystatechange = function() {
                if (xhr.readyState === XMLHttpRequest.DONE) {
                    if (xhr.status === 200) {
                        console.log('Başarılı AJAX Yanıtı:', xhr.responseText);
                        var response = JSON.parse(xhr.responseText);

                        ilceSelect.innerHTML = '<option value="">İlçe Seçiniz</option>';

                        response.forEach(function(ilce) {
                            var option = document.createElement('option');
                            option.value = ilce.id;
                            option.textContent = ilce.isim;
                            if (ilce.id == selectedIlceID) {
                                option.selected = true;
                            }
                            ilceSelect.appendChild(option);
                        });
                    } else {
                        console.error('AJAX Hatası:', xhr.status, xhr.statusText);
                        ilceSelect.innerHTML = '<option value="">İlçeler yüklenemedi</option>';
                        ilceSelect.disabled = true;
                    }
                }
            };

            xhr.send();
        } else {
            ilceSelect.innerHTML = '<option value="">İlçe Seçiniz</option>';
            ilceSelect.disabled = true;
        }
    }

    // Sayfa yüklendiğinde işletmenin mevcut ilçe setini yükle
    var initialIlID = ilSelect.value;
    var selectedIlceID = <?php echo json_encode($selectedIlceId); ?>;
    if (initialIlID) {
        loadIlceler(initialIlID, selectedIlceID);
    }

    // İl seçimi değiştiğinde ilgili ilçeleri çek
    ilSelect.addEventListener('change', function() {
        var ilID = this.value;
        console.log('Seçilen il ID:', ilID);
        loadIlceler(ilID);
    });
});
</script>


                                            <div class="col-md-12 mb-3">
                                            <label class="form-label">Adres</label>
                                                <textarea id="adres" name="adres" class="form-control"><?php echo $isletme['adres']; ?></textarea>
                                            </div>

                                        </div>
                                        <div class="row">
                                            <div class="col-md-4 mb-3">
                                                <label class="form-label">İşletme Görseli</label>
                                                <input type="file" id="gorsel" name="gorsel" class="form-control">
                                                <span class="help-block"><small><span style="color: red;">Görsel seçimi yapılmazsa; varsayılan görsel, işletme görseli olarak ayarlanır.</small></span><br>
                                                <img width="300" height="200" src="<?php echo "../". $isletme['gorsel']; ?>" alt="">
                                            </div>
                                        </div>

                                        <input type="hidden" name="islem" id="islem" value="isletmeduzenletalep">
                                        <input type="hidden" name="isletme" id="isletme" value="<?php echo $isletme['id'] ?>">
                                        <button type="button" onclick="submitForm()" class="btn btn-primary waves-effect waves-light">Kaydet</button>
                                    </form>

                                    <script>

                                        function submitForm() {
                                            // Form verilerini al
                                            var formData = new FormData(document.getElementById("myForm"));

                                            // XHR nesnesi oluştur
                                            var xhr = new XMLHttpRequest();
                                            xhr.open("POST", "netting/ajax.php", true);

                                            // AJAX isteği gönderme
                                            xhr.onload = function () {
                                                if (xhr.status === 200) {
                                                    // Başarılı yanıt işleme
                                                    var response = JSON.parse(xhr.responseText); // Sunucudan gelen JSON yanıtını işle

                                                    var deger = response.status;
                                                    var buda = response.message;
                                                    toastr[deger](buda);

                                                    toastr.options = {
                                                        "closeButton": false,
                                                        "debug": false,
                                                        "newestOnTop": false,
                                                        "progressBar": false,
                                                        "positionClass": "toast-top-right",
                                                        "preventDuplicates": false,
                                                        "onclick": null,
                                                        "showDuration": "300",
                                                        "hideDuration": "1000",
                                                        "timeOut": "5000",
                                                        "extendedTimeOut": "1000",
                                                        "showEasing": "swing",
                                                        "hideEasing": "linear",
                                                        "showMethod": "fadeIn",
                                                        "hideMethod": "fadeOut"
                                                    };

                                                    if (deger === "success") {
                                                        // Başarılı işlem
                                                        // 5 saniye sonra başka bir sayfaya yönlendir
                                                        setTimeout(function () {
                                                            //window.location.href = 'bloglar'; // Yönlendirilecek sayfanın URL'si
                                                        }, 1950); // 5 saniye bekle
                                                    }

                                                } else {
                                                    // Hata durumu
                                                    alert("Bir hata oluştu.");
                                                }
                                            };

                                            xhr.send(formData);
                                        }
                                    </script>
                                </div> <!-- end card-body -->
                            </div> <!-- end card-->
                        </div> <!-- end col -->
                    </div>
                    <!-- end row -->

                </div> <!-- container -->

            </div> <!-- content -->

            <?php include 'partials/footer.php'; ?>

        </div>

    <!-- ============================================================== -->
    <!-- End Page content -->
    <!-- ============================================================== -->


</div>
<!-- END wrapper -->

<?php include 'partials/footer-scripts.php'; ?>
<!-- third party js -->
<script src="assets/libs/selectize/js/standalone/selectize.min.js"></script>
<script src="assets/libs/mohithg-switchery/switchery.min.js"></script>
<script src="assets/libs/multiselect/js/jquery.multi-select.js"></script>
<script src="assets/libs/select2/js/select2.min.js"></script>
<script src="assets/libs/jquery-mockjax/jquery.mockjax.min.js"></script>
<script src="assets/libs/devbridge-autocomplete/jquery.autocomplete.min.js"></script>
<script src="assets/libs/bootstrap-touchspin/jquery.bootstrap-touchspin.min.js"></script>
<script src="assets/libs/bootstrap-maxlength/bootstrap-maxlength.min.js"></script>
<script src="assets/libs/toastr/build/toastr.min.js"></script>
<script src="assets/libs/dropzone/min/dropzone.min.js"></script>
<script src="assets/libs/dropify/js/dropify.min.js"></script>

<script src="assets/js/pages/toastr.init.js"></script>
<!-- third party js ends -->
<script src="assets/js/pages/datatables.init.js"></script>
<!-- Init js-->
<script src="assets/js/pages/form-advanced.init.js"></script>
<script src="assets/js/pages/form-fileuploads.init.js"></script>
<!-- App js -->
<script src="assets/js/app.min.js"></script>

</body>
</html>