<?php include 'sayfalar/header.php'; ?>

<!DOCTYPE html>
<html lang="en">

<head>

    <?php $title = "Kullanıcılar";
    include 'partials/title-meta.php'; ?>

    <?php include 'partials/head-css.php'; ?>

</head>

<?php include 'partials/body.php'; ?>

<!-- Begin page -->
<div id="wrapper">

    <?php $pagetitle = "Kullanıcılar";
    include 'partials/menu.php'; ?>
    <!-- third party css -->
    <link href="assets/libs/datatables.net-bs5/css/dataTables.bootstrap5.min.css" rel="stylesheet" type="text/css" />
    <link href="assets/libs/datatables.net-responsive-bs5/css/responsive.bootstrap5.min.css" rel="stylesheet" type="text/css" />
    <link href="assets/libs/datatables.net-buttons-bs5/css/buttons.bootstrap5.min.css" rel="stylesheet" type="text/css" />
    <link href="assets/libs/datatables.net-select-bs5/css//select.bootstrap5.min.css" rel="stylesheet" type="text/css" />
    <!-- third party css end -->

    <!-- ============================================================== -->
    <!-- Start Page Content here -->
    <!-- ============================================================== -->
            <div class="content-page">
                <div class="content">

                    <!-- Start Content-->
                    <div class="container-fluid">
                        <div class="row">
                            <div class="col-12">
                                <div class="card">
                                    <div class="card-body">
                                        <div class="row">
                                            <div class="col-md-6">
                                        <h4 class="mt-0 header-title"><?php echo $pagetitle; ?></h4>
                                        <p class="text-muted font-14 mb-3">
                                            Kullanıcılar listelenmektedir.
                                        </p></div>
                                        <div class="col-md-4"></div>
                                        <div class="col-md-2">
                                        <a href="kullanici-ekle"><button type="button" class="btn btn-success waves-effect waves-light">Yeni Ekle</button></div></a>
                                        </div>
                                        <table id="datatable-buttons" class="table table-striped table-bordered dt-responsive nowrap">
                                            <thead>
                                            <tr>
                                                <th>#</th>
                                                <th>İsim</th>
                                                <th>Telefon</th>
                                                <th width="20px">İşletme</th>
                                                <th>İşlem</th>
                                            </tr>
                                            </thead>


                                            <tbody>
                                            <?php

                                            $kullanicisor=$db->prepare("SELECT * FROM kullanici");
                                            $kullanicisor->execute();

                                            $say=0;
                                            while($kullanici=$kullanicisor->fetch(PDO::FETCH_ASSOC)) { $say++;
                                                $isletmesisor=$db->prepare("SELECT * FROM isletmeler where id=:id");
                                                $isletmesisor->execute(array(
                                                    'id' => $kullanici['isletme']
                                                ));
                                                $isletmesi=$isletmesisor->fetch(PDO::FETCH_ASSOC)
                                                ?>
                                                <tr>
                                                    <td><a href="kullanici?id=<?php echo $kullanici['id']; ?>"><?php echo $say; ?></a></td>
                                                    <td><a href="kullanici?id=<?php echo $kullanici['id']; ?>"><?php echo $kullanici['ad']. " ". $kullanici['soyad']; ?></a></td>
                                                    <td><a href="kullanici?id=<?php echo $kullanici['id']; ?>"><?php echo $kullanici['gsm']; ?></a></td>
                                                    <td><a href="kullanici?id=<?php echo $kullanici['id']; ?>"><?php echo $isletmesi['isim']; ?></a></td>
                                                    <td align="center">
                                                         <a href="kullanici?id=<?php echo $kullanici['id']; ?>"><i class="fa fa-edit fa-4"></i></a>&nbsp;&nbsp;&nbsp;&nbsp;
                                                         <a onclick="kullanicisil(<?php echo $kullanici['id']; ?>)" style="color: red;" href="#" data-id="<?php echo $kullanici['id']; ?>"><i class="fa fa-trash fa-4"></i></a>
                                                </td>
                                                
                                                </tr>
                                            <?php } ?>
                                            <script>
                                                function kullanicisil(kullaniciId) {
                                            // Form verilerini al
                                            var formData = new FormData();

                                            // 'islem' değişkenini ekle
                                            formData.append('islem', 'kullanicisil');
                                            formData.append('kullanici', kullaniciId);

                                            // XHR nesnesi oluştur
                                            var xhr = new XMLHttpRequest();
                                            xhr.open("POST", "netting/ajax.php", true);

                                            // AJAX isteği gönderme
                                            xhr.onload = function () {
                                                if (xhr.status === 200) {
                                                    // Başarılı yanıt işleme
                                                    var response = JSON.parse(xhr.responseText); // Sunucudan gelen JSON yanıtını işle

                                                    var deger = response.status;
                                                    var buda = response.message;
                                                    toastr[deger](buda);

                                                    toastr.options = {
                                                        "closeButton": false,
                                                        "debug": false,
                                                        "newestOnTop": false,
                                                        "progressBar": false,
                                                        "positionClass": "toast-top-right",
                                                        "preventDuplicates": false,
                                                        "onclick": null,
                                                        "showDuration": "300",
                                                        "hideDuration": "1000",
                                                        "timeOut": "5000",
                                                        "extendedTimeOut": "1000",
                                                        "showEasing": "swing",
                                                        "hideEasing": "linear",
                                                        "showMethod": "fadeIn",
                                                        "hideMethod": "fadeOut"
                                                    };

                                                    if (deger === "success") {
                                                        // Başarılı işlem
                                                        // 5 saniye sonra başka bir sayfaya yönlendir
                                                        setTimeout(function() {
                                                            location.reload();
                                                        }, 500); // 1000 milisaniye = 1 saniye
                                                    }

                                                } else {
                                                    // Hata durumu
                                                    alert("Bir hata oluştu.");
                                                }
                                            };

                                            xhr.send(formData);
                                        }
                                            </script>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
                <?php include 'partials/footer.php'; ?>
            </div>

        <!-- ============================================================== -->
        <!-- End Page content -->
        <!-- ============================================================== -->


    </div>
    <!-- END wrapper -->

    <?php include 'partials/footer-scripts.php'; ?>
    <!-- third party js -->
    <script src="assets/libs/datatables.net/js/jquery.dataTables.min.js"></script>
    <script src="assets/libs/datatables.net-bs5/js/dataTables.bootstrap5.min.js"></script>
    <script src="assets/libs/datatables.net-responsive/js/dataTables.responsive.min.js"></script>
    <script src="assets/libs/datatables.net-responsive-bs5/js/responsive.bootstrap5.min.js"></script>
    <script src="assets/libs/datatables.net-buttons/js/dataTables.buttons.min.js"></script>
    <script src="assets/libs/datatables.net-buttons-bs5/js/buttons.bootstrap5.min.js"></script>
    <script src="assets/libs/datatables.net-buttons/js/buttons.html5.min.js"></script>
    <script src="assets/libs/datatables.net-buttons/js/buttons.flash.min.js"></script>
    <script src="assets/libs/datatables.net-buttons/js/buttons.print.min.js"></script>
    <script src="assets/libs/datatables.net-keytable/js/dataTables.keyTable.min.js"></script>
    <script src="assets/libs/datatables.net-select/js/dataTables.select.min.js"></script>
    <script src="assets/libs/pdfmake/build/pdfmake.min.js"></script>
    <script src="assets/libs/pdfmake/build/vfs_fonts.js"></script>
    <!-- third party js ends -->
    <script src="assets/js/pages/datatables.init.js"></script>
    <!-- App js-->
    <script src="assets/js/app.min.js"></script>


    </body>
</html>