<?php include 'sayfalar/header.php'; ?>
<!DOCTYPE html>
<html lang="en">

<head>

    <?php $title = "Siparişler";
    include 'partials/title-meta.php'; ?>

    <?php include 'partials/head-css.php'; ?>

</head>

<?php include 'partials/body.php'; ?>

<!-- Begin page -->
<div id="wrapper">

    <?php $pagetitle = "Sipariş";
    include 'partials/menu.php'; ?>
    <!-- third party css -->
    <link href="assets/libs/datatables.net-bs5/css/dataTables.bootstrap5.min.css" rel="stylesheet" type="text/css" />
    <link href="assets/libs/datatables.net-responsive-bs5/css/responsive.bootstrap5.min.css" rel="stylesheet" type="text/css" />
    <link href="assets/libs/datatables.net-buttons-bs5/css/buttons.bootstrap5.min.css" rel="stylesheet" type="text/css" />
    <link href="assets/libs/datatables.net-select-bs5/css//select.bootstrap5.min.css" rel="stylesheet" type="text/css" />
    <!-- third party css end -->

    <!-- ============================================================== -->
    <!-- Start Page Content here -->
    <!-- ============================================================== -->
    <?php if ($_GET['goruntule']) {


        $siparissor=$db->prepare("SELECT * FROM siparis where id=:id");
        $siparissor->execute(array(
            'id' => $_GET['goruntule']
        ));
        $sipariscek=$siparissor->fetch(PDO::FETCH_ASSOC);
        if (empty($sipariscek['idkullanici'])) {

            $isim=$sipariscek['ad'] . " " . $sipariscek['soyad'];
        }
        else {

            $skullanicisor=$db->prepare("SELECT * FROM kullanici where kullanici_id=:id");
            $skullanicisor->execute(array(
                'id' => $sipariscek['idkullanici']
            ));
            $skullanicicek=$skullanicisor->fetch(PDO::FETCH_ASSOC);

            $isim=$skullanicicek['kullanici_adsoyad'];
        }

        ?>
    <div class="content-page">
        <div class="content">

            <!-- Start Content-->
            <div class="container-fluid">

                <div class="row">
                    <div class="col-md-12">
                        <div class="card">
                            <div class="card-body">

                                <div class="panel-body">
                                    <div class="clearfix">
                                        <div class="float-start">
                                            <h3><?php echo $ayarcek['ayar_title']; ?></h3>
                                        </div>
                                        <div class="float-end">
                                            <h4>Sipariş # <br>
                                                <strong><?php echo $sipariscek['siparis_no']; ?></strong>
                                            </h4>
                                        </div>
                                    </div>
                                    <hr>
                                    <div class="row">
                                        <div class="col-md-12">

                                            <div class="float-start mt-3">
                                                <address>
                                                    <strong><?php echo $isim; ?></strong><br>
                                                    <?php echo $sipariscek['adres']; ?><br>
                                                    <?php echo $sipariscek['ilce'] . " / " . $sipariscek['il']; ?><br>
                                                    <abbr title="Sipariş sahibinin telefon numarası">Telefon:</abbr> <?php echo $sipariscek['telefon']; ?>
                                                </address>
                                            </div>
                                            <div class="float-end mt-3">
                                                <p><strong>Sipariş Tarihi: </strong> <?php echo $sipariscek['tarih']; ?></p>
                                                <p class="m-t-10"><strong>Sipariş Durumu: </strong> <span class="label label-pink">
                                                        <?php if ($sipariscek['durum']==1) { ?>
                                                        Yeni Sipariş
                                                        <?php } elseif ($sipariscek['durum']==2) { ?>
                                                        Onay Bekliyor
                                                        <?php } elseif ($sipariscek['durum']==3) { ?>
                                                        Onaylandı
                                                        <?php } elseif ($sipariscek['durum']==4) { ?>
                                                        Kargoda
                                                        <?php } else { echo "Sipariş durumu getirilemedi."; } ?>
                                                    </span></p>
                                                <p class="m-t-10"><strong><abbr title="Şu ana kadar gelmiş siparişlerin hepsi arasındaki sırası">Sipariş Sırası</abbr>: </strong> #<?php echo $sipariscek['id']; ?></p>
                                            </div>
                                        </div><!-- end col -->
                                    </div>
                                    <!-- end row -->

                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="table-responsive">
                                                <table class="table mt-4">
                                                    <thead>
                                                    <tr><th>#</th>
                                                        <th>Ürün</th>
                                                        <th>Açıklaması</th>
                                                        <th>Adet</th>
                                                        <th>Birim Fiyat</th>
                                                        <th>Toplam Fiyat</th>
                                                    </tr></thead>
                                                    <tbody>
                                                    <tr>
                                                        <td>1</td>
                                                        <td>LCD</td>
                                                        <td>Lorem ipsum dolor sit amet.</td>
                                                        <td>1</td>
                                                        <td>$380</td>
                                                        <td>$380</td>
                                                    </tr>
                                                    <tr>
                                                        <td>2</td>
                                                        <td>Mobile</td>
                                                        <td>Lorem ipsum dolor sit amet.</td>
                                                        <td>5</td>
                                                        <td>$50</td>
                                                        <td>$250</td>
                                                    </tr>
                                                    <tr>
                                                        <td>3</td>
                                                        <td>LED</td>
                                                        <td>Lorem ipsum dolor sit amet.</td>
                                                        <td>2</td>
                                                        <td>$500</td>
                                                        <td>$1000</td>
                                                    </tr>
                                                    <tr>
                                                        <td>4</td>
                                                        <td>LCD</td>
                                                        <td>Lorem ipsum dolor sit amet.</td>
                                                        <td>3</td>
                                                        <td>$300</td>
                                                        <td>$900</td>
                                                    </tr>
                                                    <tr>
                                                        <td>5</td>
                                                        <td>Mobile</td>
                                                        <td>Lorem ipsum dolor sit amet.</td>
                                                        <td>5</td>
                                                        <td>$80</td>
                                                        <td>$400</td>
                                                    </tr>
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-xl-6 col-6">
                                            <div class="clearfix mt-4">
                                                <h2 class="text-dark fw-normal">
                                                    <?php if ($sipariscek['odeme_yontemi']==1 && $sipariscek['kredi_karti_odeme']==1) { echo "Kredi Kartıyla Güvenli Ödendi"; }
                                                    elseif ($sipariscek['odeme_yontemi']==2 && $sipariscek['havale_odeme']==1) { echo "HAVALE-EFT ile ödendi."; }
                                                    else { echo "Ödeme başarısız"; } ?></h2>
                                            </div>
                                        </div>
                                        <div class="col-xl-3 col-6 offset-xl-3">
                                            <p class="text-end"><b>Ara toplam:</b> 2930.00</p>
                                            <p class="text-end">KDV: 20%</p>
                                            <p class="text-end">Kargo: 30₺</p>
                                            <hr>
                                            <h3 class="text-end">₺ 2930.00</h3>
                                        </div>
                                    </div>
                                    <hr>
                                    <div class="d-print-none">
                                        <div class="float-end">
                                            <a href="javascript:window.print()" class="btn btn-dark waves-effect waves-light"><i class="fa fa-print"></i> Yazdır</a>
                                            <a href="siparis" class="btn btn-danger waves-effect waves-light">Kapat</a>
                                            <a href="siparis?duzenle=<?php echo $sipariscek['id']; ?>" class="btn btn-warning waves-effect waves-light">Düzenle</a>
                                        </div>
                                        <div class="clearfix"></div>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>

                </div>
                <!-- end row -->

            </div> <!-- container-fluid -->

        </div> <!-- content -->

    <?php } elseif ($_GET['duzenle']) {


        $siparissor=$db->prepare("SELECT * FROM siparis where id=:id");
        $siparissor->execute(array(
            'id' => $_GET['duzenle']
        ));
        $sipariscek=$siparissor->fetch(PDO::FETCH_ASSOC);
        if (empty($sipariscek['idkullanici'])) {

            $isim=$sipariscek['ad'] . " " . $sipariscek['soyad'];
        }
        else {

            $skullanicisor=$db->prepare("SELECT * FROM kullanici where kullanici_id=:id");
            $skullanicisor->execute(array(
                'id' => $sipariscek['idkullanici']
            ));
            $skullanicicek=$skullanicisor->fetch(PDO::FETCH_ASSOC);

            $isim=$skullanicicek['kullanici_adsoyad'];
        }

        ?>

        <div class="content-page">
            <div class="content">

                <!-- Start Content-->
                <div class="container-fluid">


                    <!-- Form row -->
                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-body">
                                    <h4 class="header-title">Sipariş: <?php echo $sipariscek['siparis_no']; ?></h4>
                                    <p class="text-muted font-13"><?php echo $sipariscek['tarih']. " tarihli ". $isim. " adlı kullanıcının siparişini görüntülüyorsunuz." ?></p>

                                    <form id="myForm">
                                        <div class="row">
                                            <div class="col-md-4 mb-3">
                                                <label class="form-label">İsim</label>
                                                <input type="text" id="ad" class="form-control" name="ad" readonly="" value="<?php echo $sipariscek['ad']; ?>">
                                            </div>
                                            <div class="col-md-4 mb-3">
                                                <label class="form-label">Soyisim</label>
                                                <input type="text" id="soyad" class="form-control" name="soyad" readonly="" value="<?php echo $sipariscek['soyad']; ?>">
                                            </div>
                                            <div class="col-md-4 mb-3">
                                                <label class="form-label">TC Kimlik Numarası</label>
                                                <input type="text" id="tc" class="form-control" name="tc" readonly="" value="<?php echo $sipariscek['tc']; ?>">
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-md-6 mb-3">
                                                <label class="form-label">Kargo Firması</label>
                                                <select class="form-select" id="kargo_firma" name="kargo_firma">
                                                    <option <?php if ($sipariscek['kargo_firma']=="yurtici") { echo "selected"; } ?> value="yurtici">Yurtiçi Kargo</option>
                                                    <option <?php if ($sipariscek['kargo_firma']=="aras") { echo "selected"; } ?> value="aras">Aras Kargo</option>
                                                    <option <?php if ($sipariscek['kargo_firma']=="mng") { echo "selected"; } ?> value="mng">MNG Kargo</option>
                                                    <option <?php if ($sipariscek['kargo_firma']=="other") { echo "selected"; } ?> value="other">Diğer</option>
                                                </select>
                                            </div>
                                            <div class="col-md-6 mb-3">
                                                <label class="form-label">Kargo Takip Numarası</label>
                                                <input type="text" id="kargo_id" name="kargo_id" class="form-control" value="<?php echo $sipariscek['kargo_id']; ?>">
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-md-3 mb-3">
                                                <label class="form-label">Sipariş Durumu</label>
                                                <select class="form-select" id="durum" name="durum">
                                                    <option <?php if ($sipariscek['durum']=="1") { echo "selected"; } ?> disabled value="1">YENI</option>
                                                    <option <?php if ($sipariscek['durum']=="2") { echo "selected"; } ?> value="2">ONAY BEKLIYOR</option>
                                                    <option <?php if ($sipariscek['durum']=="3") { echo "selected"; } ?> value="3">ONAYLANDI</option>
                                                    <option <?php if ($sipariscek['durum']=="4") { echo "selected"; } ?> value="4">KARGOLANDI</option>
                                                    <option <?php if ($sipariscek['durum']=="5") { echo "selected"; } ?> value="5">IADE</option>
                                                </select>
                                            </div>
                                        </div>
                                        <input type="hidden" id="siparis_id" name="siparis_id" value="<?php echo $sipariscek['id']; ?>">
                                        <input type="hidden" id="islem" name="islem" value="<?php echo "siparisduzenle"; ?>">
                                        <input type="submit" class="btn btn-primary waves-effect waves-light" value="Kaydet">

                                    </form>
                                    <a href="siparis"><button class="btn btn-danger waves-effect waves-light">Geri dön</button></a> <span class="help-block"><small>Değişiklik yapmadıysanız kaydetmenize gerek yok.</small></span>
                                    <script>
                                        document.getElementById("myForm").addEventListener("submit", function (e) {
                                            e.preventDefault(); // Sayfanın yeniden yüklenmesini engeller

                                            var formData = new FormData(this);

                                            // AJAX isteği oluşturma
                                            var xhr = new XMLHttpRequest();
                                            xhr.open("POST", "netting/ajax.php", true);

                                            // AJAX isteği gönderme
                                            xhr.onload = function () {
                                                if (xhr.status === 200) {
                                                    // Başarılı yanıt işleme
                                                    var response = xhr.responseText;
                                                    alert(response); // Sunucudan dönen yanıtı görüntüleme
                                                } else {
                                                    // Hata durumu
                                                    alert("Bir hata oluştu.");
                                                }
                                            };

                                            xhr.send(formData);
                                        });
                                    </script>
                                </div> <!-- end card-body -->
                            </div> <!-- end card-->
                        </div> <!-- end col -->
                    </div>
                    <!-- end row -->

                </div> <!-- container -->

            </div> <!-- content -->

            <?php include 'partials/footer.php'; ?>

        </div>
        <?php } else { ?>
        <div class="content-page">
            <div class="content">

                <!-- Start Content-->
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-body">
                                    <h4 class="mt-0 header-title"><?php echo $pagetitle; ?> Listesi</h4>
                                    <p class="text-muted font-14 mb-3">
                                        Sitenizin destek bölümünden gelen mesajlar burada listelenmektedir.
                                    </p>

                                    <table id="datatable-buttons" class="table table-striped table-bordered dt-responsive nowrap">
                                        <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>İsim</th>
                                            <th>Tarih</th>
                                            <th>Tutar</th>
                                            <th align="center">Durum</th>
                                            <th>İşlem</th>
                                        </tr>
                                        </thead>


                                        <tbody>
                                        <?php

                                        $siparissor=$db->prepare("SELECT * FROM siparis order by id DESC LIMIT 5");
                                        $siparissor->execute();

                                        $say=0;
                                        while($sipariscek=$siparissor->fetch(PDO::FETCH_ASSOC)) { $say++;

                                            if (empty($sipariscek['idkullanici'])) {

                                                $isim=$sipariscek['ad'] . " " . $sipariscek['soyad'];
                                            }
                                            else {

                                                $skullanicisor=$db->prepare("SELECT * FROM kullanici where kullanici_id=:id");
                                                $skullanicisor->execute(array(
                                                    'id' => $sipariscek['idkullanici']
                                                ));
                                                $skullanicicek=$skullanicisor->fetch(PDO::FETCH_ASSOC);

                                                $isim=$skullanicicek['kullanici_adsoyad'];
                                            }
                                            ?>
                                            <tr>
                                                <td><a href="siparis?goruntule=<?php echo $sipariscek['id']; ?>"><?php echo $say; ?></a></td>
                                                <td><a href="siparis?goruntule=<?php echo $sipariscek['id']; ?>"><?php echo $isim; ?></a></td>
                                                <td><a href="siparis?goruntule=<?php echo $sipariscek['id']; ?>"><?php echo $sipariscek['tarih']; ?></a></td>
                                                <td><a href="siparis?goruntule=<?php echo $sipariscek['id']; ?>"><?php echo $sipariscek['toplam_tutar']; ?></a></td>
                                                <?php if ($sipariscek['durum']==1) { ?>
                                                    <td align="center"><a href="siparis?goruntule=<?php echo $sipariscek['id']; ?>"><span class="badge bg-danger">YENI SIPARIS</span></a></td>
                                                <?php } elseif ($sipariscek['durum']==2) { ?>
                                                    <td align="center"><a href="siparis?goruntule=<?php echo $sipariscek['id']; ?>"><span class="badge bg-warning">ONAY BEKLIYOR</span></a></td>
                                                <?php } elseif ($sipariscek['durum']==3) { ?>
                                                    <td align="center"><a href="siparis?goruntule=<?php echo $sipariscek['id']; ?>"><span class="badge bg-success">ONAYLANDI</span></a></td>
                                                <?php } elseif ($sipariscek['durum']==4) { ?>
                                                    <td align="center"><a href="siparis?goruntule=<?php echo $sipariscek['id']; ?>"><span class="badge bg-blue">KARGODA</span></a></td>
                                                <?php } ?>
                                                <td align="center"><a href="siparis?goruntule=<?php echo $sipariscek['id']; ?>"><i class="fas fa-eye"></i></a>   &nbsp;&nbsp;&nbsp; <a href="siparis?duzenle=<?php echo $sipariscek['id']; ?>"><i class="fas fa-edit"></i></a>  &nbsp;&nbsp;&nbsp; <a href="siparis?sil=<?php echo $sipariscek['id']; ?>"><i class="fas fa-trash"></i></a></td>
                                            </tr>
                                        <?php } ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
            <?php include 'partials/footer.php'; ?>
        </div>
    <?php } ?>

    <!-- ============================================================== -->
    <!-- End Page content -->
    <!-- ============================================================== -->


</div>
<!-- END wrapper -->

<?php include 'partials/footer-scripts.php'; ?>
<!-- third party js -->
<script src="assets/libs/datatables.net/js/jquery.dataTables.min.js"></script>
<script src="assets/libs/datatables.net-bs5/js/dataTables.bootstrap5.min.js"></script>
<script src="assets/libs/datatables.net-responsive/js/dataTables.responsive.min.js"></script>
<script src="assets/libs/datatables.net-responsive-bs5/js/responsive.bootstrap5.min.js"></script>
<script src="assets/libs/datatables.net-buttons/js/dataTables.buttons.min.js"></script>
<script src="assets/libs/datatables.net-buttons-bs5/js/buttons.bootstrap5.min.js"></script>
<script src="assets/libs/datatables.net-buttons/js/buttons.html5.min.js"></script>
<script src="assets/libs/datatables.net-buttons/js/buttons.flash.min.js"></script>
<script src="assets/libs/datatables.net-buttons/js/buttons.print.min.js"></script>
<script src="assets/libs/datatables.net-keytable/js/dataTables.keyTable.min.js"></script>
<script src="assets/libs/datatables.net-select/js/dataTables.select.min.js"></script>
<script src="assets/libs/pdfmake/build/pdfmake.min.js"></script>
<script src="assets/libs/pdfmake/build/vfs_fonts.js"></script>
<!-- third party js ends -->
<script src="assets/js/pages/datatables.init.js"></script>
<!-- App js-->
<script src="assets/js/app.min.js"></script>


</body>
</html>