<?php include 'sayfalar/header.php'; ?>
<!DOCTYPE html>
<html lang="en">

<head>

    <?php $title = "Ürün";
    include 'partials/title-meta.php'; ?>
    <!-- Plugins css -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="ckeditor/build/ckeditor.js"></script>
    <link href="assets/libs/mohithg-switchery/switchery.min.css" rel="stylesheet" type="text/css" />
    <link href="assets/libs/multiselect/css/multi-select.css" rel="stylesheet" type="text/css" />
    <link href="assets/libs/select2/css/select2.min.css" rel="stylesheet" type="text/css" />
    <link href="assets/libs/selectize/css/selectize.bootstrap3.css" rel="stylesheet" type="text/css" />
    <link href="assets/libs/bootstrap-touchspin/jquery.bootstrap-touchspin.min.css" rel="stylesheet" type="text/css" />
    <link href="assets/libs/toastr/build/toastr.min.css" rel="stylesheet" type="text/css" />
    <link href="assets/libs/dropzone/min/dropzone.min.css" rel="stylesheet" type="text/css" />
    <link href="assets/libs/dropify/css/dropify.min.css" rel="stylesheet" type="text/css" />
    <?php include 'partials/head-css.php'; ?>


</head>
<style>
    .image-container {
        position: relative;
        display: inline-block;
    }

    .delete-overlay {
        position: absolute;
        top: 50%;
        left: 50%;
        transform: translate(-50%, -50%);
        background-color: rgba(255, 0, 0, 0.7);
        color: white;
        padding: 10px;
        box-sizing: border-box;
        opacity: 0;
        text-align: center;
        line-height: 1.5;
        cursor: pointer;
        transition: opacity 0.3s;
    }

    .image-container:hover .delete-overlay {
        opacity: 1;
    }
</style>
<?php include 'partials/body.php'; ?>

<!-- Begin page -->
<div id="wrapper">

    <?php $pagetitle = "Ürün";
    include 'partials/menu.php'; ?>
    <!-- third party css -->

    <!-- third party css end -->

    <!-- ============================================================== -->
    <!-- Start Page Content here -->
    <!-- ============================================================== -->
    <?php if ($_GET['duzenle']) {

        $urunsor=$db->prepare("SELECT * FROM urun where id=:id");
    $urunsor->execute(array(
            'id' => $_GET['duzenle']
        ));
    $urun=$urunsor->fetch(PDO::FETCH_ASSOC);

        ?>

        <div class="content-page">
            <div class="content">

                <!-- Start Content-->
                <div class="container-fluid">


                    <!-- Form row -->
                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-body">
                                    <h4 class="header-title">Ürün Düzenle</h4>
                                    <p class="text-muted font-13"><?php echo $urun['baslik'] . " adlı ürünü düzenliyorsunuz."; ?></p>

                                    <form id="myForm" enctype="multipart/form-data">
                                        <div class="row">
                                            <div class="col-md-5 mb-3">
                                                <label class="form-label">Ürün Başlığı</label>
                                                <input type="text" id="baslik" class="form-control" name="baslik" value="<?php echo $urun['baslik']; ?>" required>
                                            </div>
                                            <div class="col-md-4 mb-3">
                                                <label class="form-label">Etiket</label>
                                                <input type="text" id="selectize-tags" name="etiket" value="<?php echo $urun['etiket']; ?>">
                                                <span class="help-block"><small>Lütfen etiketi girip <strong>enter</strong> tuşuna basınız.</small></span><br>
                                                <span class="help-block"><small>Silmek istediğiniz etiketi yön tuşlarıyla hareket ederek silebilirsiniz.</small></span>
                                            </div>
                                            <div class="col-md-2 mb-3">
                                                <label class="form-label">Eski Fiyat</label>
                                                <input class="form-control" id="eski_fiyat" type="number" min="0" name="eski_fiyat" value="<?php echo $urun['eski_fiyat']; ?>">
                                                <span class="help-block"><small>Eski fiyat girmezseniz indirimsiz gözükür.</small></span>
                                            </div>
                                            <div class="col-md-1     mb-3">
                                                <label class="form-label">Fiyat</label>
                                                <input class="form-control" id="fiyat" type="number" min="0" name="fiyat" value="<?php echo $urun['fiyat']; ?>" required>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-md-2 mb-3">
                                                <label class="form-label">Durum</label>
                                                <select class="form-select" id="durum" name="durum">
                                                    <option value="1" <?php if ($urun['durum']==1) { echo "selected"; } ?>>Aktif</option>
                                                    <option value="0" <?php if ($urun['durum']==0) { echo "selected"; } ?>>Pasif</option>
                                                </select>
                                            </div>
                                            <div class="col-md-1 mb-3">
                                                <label class="form-label">Stok</label>
                                                <input class="form-control" id="stok" type="number" min="0" name="stok" value="<?php echo $urun['stok']; ?>" required>
                                            </div>
                                            <div class="col-md-3 mb-3">
                                                <label class="form-label">Kategori</label>
                                                <select class="form-control" data-toggle="select2" id="kategori" name="kategori" data-width="100%" required>
                                                    <optgroup label="Ürün Kategorileri">
                                                        <?php

                                                        $kategorisor=$db->prepare("SELECT * FROM kategoriler order by id ASC");
                                                        $kategorisor->execute();

                                                        while($kategoricek=$kategorisor->fetch(PDO::FETCH_ASSOC)) { ;

                                                            ?>
                                                            <option <?php if ($urun['kategori']==$kategoricek['id']) { echo "selected"; } ?> value="<?php echo $kategoricek['id']; ?>"><?php echo $kategoricek['baslik']; ?></option>
                                                        <?php } ?>
                                                    </optgroup>
                                                </select>
                                            </div>
                                            <div class="col-md-3 mb-3">
                                                <label class="form-label">Ürün Kodu</label>
                                                <input class="form-control" id="kod" type="text" maxlength="28" name="kod" value="<?php echo $urun['kod']; ?>" required>
                                            </div>
                                            <div class="col-md-3 mb-3">
                                                <label class="form-label">Ürün Kdvsi</label>
                                                <select class="form-control" data-toggle="select2" id="kdv" name="kdv" data-width="100%" required>
                                                    <?php

                                                    $kdvsor=$db->prepare("SELECT * FROM kdv order by deger asc");
                                                    $kdvsor->execute();

                                                    while($kdv=$kdvsor->fetch(PDO::FETCH_ASSOC)) { ;
                                                        ?>
                                                        <option <?php if ($urun['kdv']==$kdv['id']) { echo "selected"; } ?> value="<?php echo "1.". $kdv['deger']; ?>"><?php echo $kdv['oran']; ?></option>
                                                    <?php } ?>
                                                </select>
                                                <span class="help-block"><small>Kdv oranlarını <a href="kdv" target="_blank">buraya</a> tıklayarak belirleyebilirsiniz.</small></span>
                                            </div>
                                            <div class="col-md-12 mb-3">
                                                <textarea id="content" name="textareaContent" class="form-control"><?php echo $urun['detay']; ?></textarea>
                                            </div>
                                            <input type="hidden" id="editorContent" name="hiddenContent">

                                            <!-- CKEditor'i başlatın -->
                                            <script>
                                                ClassicEditor
                                                    .create(document.querySelector('#content'), {
                                                        ckfinder: {
                                                            uploadUrl: 'fileupload.php'
                                                        }
                                                    })
                                                    .then(editor => {
                                                        console.log(editor);

                                                        document.getElementById('editorContent').value = editor.getData();
                                                        // CKEditor içeriği değiştiğinde, gizli alana güncellenmiş içeriği ekleyin
                                                        editor.model.document.on('change:data', () => {
                                                            document.getElementById('editorContent').value = editor.getData();
                                                        });
                                                    })
                                                    .catch(error => {
                                                        console.error(error);
                                                    });
                                            </script>

                                        </div>
                                        <div class="row">
                                            <div class="col-md-4 mb-3">
                                                <label class="form-label">Ürün Görseli</label>
                                                <input type="file" id="gorsel" name="gorsel" class="form-control">
                                            </div>
                                            <div class="col-md-2 mb-3">
                                                <img height="85px" src="../<?php echo $urun['gorsel1']; ?>" alt="">
                                            </div>
                                            <div class="col-md-6 mb-3">
                                                <label for="example-helping" class="form-label">SEO Url</label>
                                                <input type="text" id="seo" name="seo" class="form-control" value="<?php echo $urun['seo_sef']; ?>" oninput="updateLink()">
                                                <span class="help-block"><small><span style="color: red;">SEO,</span> url kısmındaki <?php echo $ayarcek['ayar_url']; ?><span style="color: blue;" id="example-seo">ornek-seo</span> işaretli yeri ifade eder ve benzersiz olmalıdır.</small></span><br>
                                                <span class="help-block"><small id="enteredLink"></small></span>

                                                <script>
                                                    function updateLink() {

                                                        var seoValue = document.getElementById('seo').value;

                                                        seoValue = turkceKarakterDuzelt(seoValue);

                                                        var domain = '<?php echo $ayarcek['ayar_url']; ?>';

                                                        document.getElementById('enteredLink').innerHTML = '<span style="color: orange;">' + domain + seoValue + '</span>';                                                    }

                                                    function turkceKarakterDuzelt(str) {
                                                        var turkceKarakterler = { 'ı': 'i', 'İ': 'I', 'ğ': 'g', 'Ğ': 'G', 'ü': 'u', 'Ü': 'U', 'ş': 's', 'Ş': 'S', 'ö': 'o', 'Ö': 'O', 'ç': 'c', 'Ç': 'C' };

                                                        return str.replace(/[ıİğĞüÜşŞöÖçÇ]/g, function (char) {
                                                            return turkceKarakterler[char] || char;
                                                        });
                                                    }
                                                </script>
                                            </div>
                                            <div class="col-md-12 mb-3">
                                                <label for="example-helping" class="form-label">Öne Çıkan Ürün</label>
                                                <input type="checkbox" <?php if($urun['onecikan']==1) { echo "checked"; } ?> class="form-check-input" id="onecikan" name="onecikan" value="1">
                                            </div>
                                        </div>
                                        <hr>
                                        <h3 class=" text-center"><span style="color: red;"><u>Ürün Seçenekleri</u></span></h3>
                                        <div id="optionsContainer">
                                            <?php
                                            $seceneksor = $db->prepare("SELECT * FROM urun_secenek where urun=:urun and tur=:tur order by id ASC");
                                            $seceneksor->execute(array(
                                                'urun' => $urun['id'],
                                                'tur' => 2
                                            ));
                                            $counter = 0; // Sıralı numara tutmak için bir sayaç
                                            while ($secenek = $seceneksor->fetch(PDO::FETCH_ASSOC)) {
                                                ?>
                                                <div class="row optionRow" data-counter="<?php echo $counter; ?>">
                                                    <div class="col-md-3 mb-3">
                                                        <label class="form-label">Seçenek İsmi</label>
                                                        <input class="form-control" type="text" name="optionName[<?php echo $counter; ?>]" value="<?php echo $secenek['isim']; ?>" required>
                                                    </div>
                                                    <div class="col-md-3 mb-3">
                                                        <label class="form-label">Seçenek Ücreti</label>
                                                        <input class="form-control" type="number" name="optionPrice[<?php echo $counter; ?>]" value="<?php echo $secenek['fiyat']; ?>" required>
                                                    </div>
                                                    <div class="col-md-2 mb-3">
                                                        <label class="form-label">Fiyat Yönü</label>
                                                        <select class="form-control" name="optionQuantity[<?php echo $counter; ?>]">
                                                            <option <?php if ($secenek['artieksi'] == "+") {
                                                                echo "selected";
                                                            } ?> value="+">+</option>
                                                            <option <?php if ($secenek['artieksi'] == "-") {
                                                                echo "selected";
                                                            } ?> value="-">-</option>
                                                        </select>
                                                    </div>
                                                    <div class="col-md-2 mb-3">
                                                        <label class="form-label"></label><br>
                                                        <button type="button" class="btn btn-danger" onclick="removeOption(this)" style="color: white; background-color: red;">Sil</button>
                                                    </div>
                                                </div>
                                                <?php
                                                $counter++;
                                            } ?>
                                            <!-- Burada bir tane seçenek satırını göstermiyoruz, çünkü henüz seçenek eklenmemiş -->
                                        </div>
                                        <hr>

                                        <button type="button" onclick="addOption()" class="btn btn-success">Yeni Seçenek Ekle</button>
                                        <input type="hidden" name="islem" id="islem" value="urunduzenle">
                                        <input type="hidden" name="id" id="id" value="<?php echo $urun['id']; ?>">
                                        <input type="hidden" name="eski_sef" id="eski_sef" value="<?php echo $urun['seo_sef']; ?>">
                                        <button type="button" onclick="submitForm()" class="btn btn-primary waves-effect waves-light">Kaydet</button>
                                    </form>
                                        <script>
                                            var counter = <?php echo $counter; ?>;

                                            function addOption() {
                                                // Yeni seçenek satırını oluştur
                                                var newOptionRow = document.createElement('div');
                                                newOptionRow.className = 'row optionRow';
                                                newOptionRow.dataset.counter = counter;
                                                // Seçenek ismi alanı
                                                var optionNameInput = document.createElement('div');
                                                optionNameInput.className = 'col-md-3 mb-3';
                                                optionNameInput.innerHTML = '<label class="form-label">Seçenek İsmi</label><input class="form-control" type="text" name="optionName[]" required>';
                                                newOptionRow.appendChild(optionNameInput);

                                                // Seçenek ücreti alanı
                                                var optionPriceInput = document.createElement('div');
                                                optionPriceInput.className = 'col-md-3 mb-3';
                                                optionPriceInput.innerHTML = '<label class="form-label">Seçenek Ücreti</label><input class="form-control" type="number" name="optionPrice[]" required>';
                                                newOptionRow.appendChild(optionPriceInput);

                                                // Artı ve Eksi seçenekleri
                                                var quantitySelect = document.createElement('div');
                                                quantitySelect.className = 'col-md-2 mb-3';
                                                quantitySelect.innerHTML = '<label class="form-label">Fiyat Yönü</label><select class="form-control" name="optionQuantity[]"><option value="+">+</option><option value="-">-</option></select>';
                                                newOptionRow.appendChild(quantitySelect);

                                                // Sil butonu
                                                var deleteButton = document.createElement('div');
                                                deleteButton.className = 'col-md-1 mb-3';
                                                deleteButton.innerHTML = '<label class="form-label"></label><br><button type="button" class="btn btn-danger" onclick="removeOption(this)" style="color: white; background-color: red;">Sil</button>';
                                                newOptionRow.appendChild(deleteButton);

                                                // Yeni seçenek satırını optionsContainer'a ekle
                                                document.getElementById('optionsContainer').appendChild(newOptionRow);
                                            }

                                            function removeOption(button) {
                                                // Tıklanan butonun üstündeki satırı sil
                                                var optionRow = button.closest('.optionRow');
                                                optionRow.parentNode.removeChild(optionRow);
                                            }

                                        function submitForm() {
                                            // Form verilerini al
                                            var formData = new FormData(document.getElementById("myForm"));

                                            formData.append('gorsel', document.getElementById('gorsel').files[0]);

                                            var editorContent = document.getElementById('editorContent').value;
                                            formData.append("content", editorContent);

                                            // Seçenek isimlerini ve ücretlerini ayrı ayrı dizi olarak al
                                            var optionNames = document.getElementsByName("optionName[]");
                                            var optionPrices = document.getElementsByName("optionPrice[]");

                                            // FormData'ya seçenek isimlerini ekle
                                            for (var i = 0; i < optionNames.length; i++) {
                                                formData.append("optionNames[]", optionNames[i].value);
                                            }

                                            // FormData'ya seçenek ücretlerini ekle
                                            for (var i = 0; i < optionPrices.length; i++) {
                                                formData.append("optionPrices[]", optionPrices[i].value);
                                            }

                                            // XHR nesnesi oluştur
                                            var xhr = new XMLHttpRequest();
                                            xhr.open("POST", "netting/ajax.php", true);

                                            // AJAX isteği gönderme
                                            xhr.onload = function () {
                                                if (xhr.status === 200) {
                                                    // Başarılı yanıt işleme
                                                    var response = JSON.parse(xhr.responseText); // Sunucudan gelen JSON yanıtını işle

                                                    var deger = response.status;
                                                    var buda = response.message;
                                                    toastr[deger](buda);

                                                    toastr.options = {
                                                        "closeButton": false,
                                                        "debug": false,
                                                        "newestOnTop": false,
                                                        "progressBar": false,
                                                        "positionClass": "toast-top-right",
                                                        "preventDuplicates": false,
                                                        "onclick": null,
                                                        "showDuration": "300",
                                                        "hideDuration": "1000",
                                                        "timeOut": "5000",
                                                        "extendedTimeOut": "1000",
                                                        "showEasing": "swing",
                                                        "hideEasing": "linear",
                                                        "showMethod": "fadeIn",
                                                        "hideMethod": "fadeOut"
                                                    };

                                                    if (deger === "success") {
                                                        // Başarılı işlem
                                                        // 5 saniye sonra başka bir sayfaya yönlendir
                                                        //setTimeout(function () {
                                                        //    window.location.href = 'bloglar'; // Yönlendirilecek sayfanın URL'si
                                                        //}, 1950); // 5 saniye bekle
                                                    }

                                                } else {
                                                    // Hata durumu
                                                    alert("Bir hata oluştu.");
                                                }
                                            };

                                            xhr.send(formData);
                                        }
                                    </script>

                                </div> <!-- end card-body -->
                            </div> <!-- end card-->
                        </div> <!-- end col -->
                    </div>
                    <!-- end row -->

                </div> <!-- container -->

            </div> <!-- content -->

            <?php include 'partials/footer.php'; ?>

        </div>
    <?php } else { ?>

        <div class="content-page">
            <div class="content">

                <!-- Start Content-->
                <div class="container-fluid">


                    <!-- Form row -->
                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-body">
                                    <h4 class="header-title">Ürün Ekle</h4>
                                    <p class="text-muted font-13">Yeni ürün ekle.</p>

                                    <form id="myForm">
                                        <div class="row">
                                            <div class="col-md-5 mb-3">
                                                <label class="form-label">Ürün Başlığı</label>
                                                <input type="text" id="baslik" class="form-control" name="baslik" required>
                                            </div>
                                            <div class="col-md-4 mb-3">
                                                <label class="form-label">Etiket</label>
                                                <input type="text" id="selectize-tags" name="etiket">
                                                <span class="help-block"><small>Lütfen etiketi girip <strong>enter</strong> tuşuna basınız.</small></span><br>
                                                <span class="help-block"><small>Silmek istediğiniz etiketi yön tuşlarıyla hareket ederek silebilirsiniz.</small></span>
                                            </div>
                                            <div class="col-md-2 mb-3">
                                                <label class="form-label">Eski Fiyat</label>
                                                <input class="form-control" id="eski_fiyat" type="number" min="0" name="eski_fiyat">
                                                <span class="help-block"><small>Eski fiyat girmezseniz indirimsiz gözükür.</small></span>
                                            </div>
                                            <div class="col-md-1     mb-3">
                                                <label class="form-label">Fiyat</label>
                                                <input class="form-control" id="fiyat" type="number" min="0" name="fiyat" required>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-md-2 mb-3">
                                                <label class="form-label">Durum</label>
                                                <select class="form-select" id="durum" name="durum">
                                                    <option value="1" selected>Aktif</option>
                                                    <option value="0">Pasif</option>
                                                </select>
                                            </div>
                                            <div class="col-md-1 mb-3">
                                                <label class="form-label">Stok</label>
                                                <input class="form-control" id="stok" type="number" min="0" name="stok" required>
                                            </div>
                                            <div class="col-md-3 mb-3">
                                                <label class="form-label">Kategori</label>
                                                <select class="form-control" data-toggle="select2" id="kategori" name="kategori" data-width="100%" required>
                                                    <optgroup label="Ürün Kategorileri">
                                                        <?php

                                                        $kategorisor=$db->prepare("SELECT * FROM kategoriler order by id ASC");
                                                        $kategorisor->execute();

                                                        while($kategoricek=$kategorisor->fetch(PDO::FETCH_ASSOC)) { ;

                                                            ?>
                                                            <option value="<?php echo $kategoricek['id']; ?>"><?php echo $kategoricek['baslik']; ?></option>
                                                        <?php } ?>
                                                    </optgroup>
                                                </select>
                                            </div>
                                            <div class="col-md-3 mb-3">
                                                <label class="form-label">Ürün Kodu</label>
                                                <input class="form-control" id="kod" type="text" maxlength="28" name="kod" required>
                                            </div>
                                            <div class="col-md-3 mb-3">
                                                <label class="form-label">Ürün Kdvsi</label>
                                                <select class="form-control" data-toggle="select2" id="kdv" name="kdv" data-width="100%" required>
                                                        <?php

                                                        $kdvsor=$db->prepare("SELECT * FROM kdv order by deger asc");
                                                        $kdvsor->execute();

                                                        while($kdv=$kdvsor->fetch(PDO::FETCH_ASSOC)) { ;
                                                            ?>
                                                            <option value="<?php echo "1.". $kdv['deger']; ?>"><?php echo $kdv['oran']; ?></option>
                                                        <?php } ?>
                                                </select>
                                                <span class="help-block"><small>Kdv oranlarını <a href="kdv" target="_blank">buraya</a> tıklayarak belirleyebilirsiniz.</small></span>
                                            </div>
                                            <div class="col-md-12 mb-3">
                                                <textarea id="content" name="content" class="form-control"></textarea>
                                            </div>
                                            <script>
                                                ClassicEditor
                                                    .create( document.querySelector( '#content' ),{
                                                        ckfinder:
                                                            {
                                                                uploadUrl: 'fileupload.php'
                                                            }
                                                    })
                                                    .then(editor => {
                                                        console.log(editor);
                                                    })
                                                    .catch( error => {
                                                        console.error( error );
                                                    });
                                            </script>

                                        </div>
                                        <div class="row">
                                            <div class="col-md-4 mb-3">
                                                <label class="form-label">Ürün Görseli</label>
                                                <input type="file" id="gorsel" name="gorsel" class="form-control">
                                            </div>
                                            <div class="col-md-6 mb-3">
                                                <label for="example-helping" class="form-label">SEO Url</label>
                                                <input type="text" id="seo" name="seo" class="form-control" oninput="updateLink()">
                                                <span class="help-block"><small><span style="color: red;">SEO,</span> url kısmındaki <?php echo $ayarcek['ayar_url']; ?><span style="color: blue;" id="example-seo">ornek-seo</span> işaretli yeri ifade eder ve benzersiz olmalıdır.</small></span><br>
                                                <span class="help-block"><small id="enteredLink"></small></span>

                                                <script>
                                                    function updateLink() {
                                                        // SEO alanının değerini al
                                                        var seoValue = document.getElementById('seo').value;

                                                        // Türkçe karakterleri düzelt
                                                        seoValue = turkceKarakterDuzelt(seoValue);

                                                        // Domain'i al
                                                        var domain = '<?php echo $ayarcek['ayar_url']; ?>';

                                                        // Girilen linki yazdır
                                                        document.getElementById('enteredLink').innerHTML = '<span style="color: orange;">' + domain + seoValue + '</span>';                                                    }

                                                    function turkceKarakterDuzelt(str) {
                                                        var turkceKarakterler = { 'ı': 'i', 'İ': 'I', 'ğ': 'g', 'Ğ': 'G', 'ü': 'u', 'Ü': 'U', 'ş': 's', 'Ş': 'S', 'ö': 'o', 'Ö': 'O', 'ç': 'c', 'Ç': 'C' };

                                                        // Türkçe karakterleri dönüştür
                                                        return str.replace(/[ıİğĞüÜşŞöÖçÇ]/g, function (char) {
                                                            return turkceKarakterler[char] || char;
                                                        });
                                                    }
                                                </script>
                                            </div>
                                        </div>
                                        <div id="optionsContainer">
                                            <!-- Burada bir tane seçenek satırını göstermiyoruz, çünkü henüz seçenek eklenmemiş -->
                                        </div>

                                        <div id="optionsContainer">
                                            <!-- Burada bir tane seçenek satırını göstermiyoruz, çünkü henüz seçenek eklenmemiş -->
                                        </div>

                                        <button type="button" onclick="addOption()" class="btn btn-success">Yeni Seçenek Ekle</button>
                                        <input type="hidden" name="islem" id="islem" value="urunekle">
                                        <button type="button" onclick="submitForm()" class="btn btn-primary waves-effect waves-light">Kaydet</button>
                                    </form>

                                    <script>
                                        function addOption() {
                                            // Yeni seçenek satırını oluştur
                                            var newOptionRow = document.createElement('div');
                                            newOptionRow.className = 'row optionRow';

                                            // Seçenek ismi alanı
                                            var optionNameInput = document.createElement('div');
                                            optionNameInput.className = 'col-md-3 mb-3';
                                            optionNameInput.innerHTML = '<label class="form-label">Seçenek İsmi</label><input class="form-control" type="text" name="optionName[]" required>';
                                            newOptionRow.appendChild(optionNameInput);

                                            // Seçenek ücreti alanı
                                            var optionPriceInput = document.createElement('div');
                                            optionPriceInput.className = 'col-md-3 mb-3';
                                            optionPriceInput.innerHTML = '<label class="form-label">Seçenek Ücreti</label><input class="form-control" type="number" name="optionPrice[]" required>';
                                            newOptionRow.appendChild(optionPriceInput);

                                            // Artı ve Eksi seçenekleri
                                            var quantitySelect = document.createElement('div');
                                            quantitySelect.className = 'col-md-2 mb-3';
                                            quantitySelect.innerHTML = '<label class="form-label">Fiyat Yönü</label><select class="form-control" name="optionQuantity[]"><option value="+">+</option><option value="-">-</option></select>';
                                            newOptionRow.appendChild(quantitySelect);

                                            // Yeni seçenek satırını optionsContainer'a ekle
                                            document.getElementById('optionsContainer').appendChild(newOptionRow);
                                        }

                                        function submitForm() {
                                            // Form verilerini al
                                            var formData = new FormData(document.getElementById("myForm"));

                                            // Seçenek isimlerini ve ücretlerini ayrı ayrı dizi olarak al
                                            var optionNames = document.getElementsByName("optionName[]");
                                            var optionPrices = document.getElementsByName("optionPrice[]");

                                            // FormData'ya seçenek isimlerini ekle
                                            for (var i = 0; i < optionNames.length; i++) {
                                                formData.append("optionNames[]", optionNames[i].value);
                                            }

                                            // FormData'ya seçenek ücretlerini ekle
                                            for (var i = 0; i < optionPrices.length; i++) {
                                                formData.append("optionPrices[]", optionPrices[i].value);
                                            }

                                            // XHR nesnesi oluştur
                                            var xhr = new XMLHttpRequest();
                                            xhr.open("POST", "netting/ajax.php", true);

                                            // AJAX isteği gönderme
                                            xhr.onload = function () {
                                                if (xhr.status === 200) {
                                                    // Başarılı yanıt işleme
                                                    var response = JSON.parse(xhr.responseText); // Sunucudan gelen JSON yanıtını işle

                                                    var deger = response.status;
                                                    var buda = response.message;
                                                    toastr[deger](buda);

                                                    toastr.options = {
                                                        "closeButton": false,
                                                        "debug": false,
                                                        "newestOnTop": false,
                                                        "progressBar": false,
                                                        "positionClass": "toast-top-right",
                                                        "preventDuplicates": false,
                                                        "onclick": null,
                                                        "showDuration": "300",
                                                        "hideDuration": "1000",
                                                        "timeOut": "5000",
                                                        "extendedTimeOut": "1000",
                                                        "showEasing": "swing",
                                                        "hideEasing": "linear",
                                                        "showMethod": "fadeIn",
                                                        "hideMethod": "fadeOut"
                                                    };

                                                    if (deger === "success") {
                                                        // Başarılı işlem
                                                        // 5 saniye sonra başka bir sayfaya yönlendir
                                                        setTimeout(function () {
                                                            window.location.href = 'bloglar'; // Yönlendirilecek sayfanın URL'si
                                                        }, 1950); // 5 saniye bekle
                                                    }

                                                } else {
                                                    // Hata durumu
                                                    alert("Bir hata oluştu.");
                                                }
                                            };

                                            xhr.send(formData);
                                        }
                                    </script>
                                </div> <!-- end card-body -->
                            </div> <!-- end card-->
                        </div> <!-- end col -->
                    </div>
                    <!-- end row -->

                </div> <!-- container -->

            </div> <!-- content -->

            <?php include 'partials/footer.php'; ?>

        </div>


    <?php } ?>

    <!-- ============================================================== -->
    <!-- End Page content -->
    <!-- ============================================================== -->


</div>
<!-- END wrapper -->

<?php include 'partials/footer-scripts.php'; ?>
<!-- third party js -->
<script src="assets/libs/selectize/js/standalone/selectize.min.js"></script>
<script src="assets/libs/mohithg-switchery/switchery.min.js"></script>
<script src="assets/libs/multiselect/js/jquery.multi-select.js"></script>
<script src="assets/libs/select2/js/select2.min.js"></script>
<script src="assets/libs/jquery-mockjax/jquery.mockjax.min.js"></script>
<script src="assets/libs/devbridge-autocomplete/jquery.autocomplete.min.js"></script>
<script src="assets/libs/bootstrap-touchspin/jquery.bootstrap-touchspin.min.js"></script>
<script src="assets/libs/bootstrap-maxlength/bootstrap-maxlength.min.js"></script>
<script src="assets/libs/toastr/build/toastr.min.js"></script>
<script src="assets/libs/dropzone/min/dropzone.min.js"></script>
<script src="assets/libs/dropify/js/dropify.min.js"></script>

<script src="assets/js/pages/toastr.init.js"></script>
<!-- third party js ends -->
<script src="assets/js/pages/datatables.init.js"></script>
<!-- Init js-->
<script src="assets/js/pages/form-advanced.init.js"></script>
<script src="assets/js/pages/form-fileuploads.init.js"></script>
<!-- App js -->
<script src="assets/js/app.min.js"></script>

</body>
</html>