<?php include 'sayfalar/header.php'; ?>
<!DOCTYPE html>
<html lang="en">

<head>

    <?php $title = "Ürünler";
    include 'partials/title-meta.php'; ?>

    <?php include 'partials/head-css.php'; ?>

</head>

<?php include 'partials/body.php'; ?>

<!-- Begin page -->
<div id="wrapper">

    <?php $pagetitle = "Ürünler";
    include 'partials/menu.php'; ?>
    <!-- third party css -->
    <link href="assets/libs/datatables.net-bs5/css/dataTables.bootstrap5.min.css" rel="stylesheet" type="text/css" />
    <link href="assets/libs/datatables.net-responsive-bs5/css/responsive.bootstrap5.min.css" rel="stylesheet" type="text/css" />
    <link href="assets/libs/datatables.net-buttons-bs5/css/buttons.bootstrap5.min.css" rel="stylesheet" type="text/css" />
    <link href="assets/libs/datatables.net-select-bs5/css//select.bootstrap5.min.css" rel="stylesheet" type="text/css" />
    <!-- third party css end -->

    <!-- ============================================================== -->
    <!-- Start Page Content here -->
    <!-- ============================================================== -->
    <div class="content-page">
        <div class="content">

            <!-- Start Content-->
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-body">
                                <h4 class="mt-0 header-title"><?php echo $pagetitle; ?> Listesi</h4>
                                <p class="text-muted font-14 mb-3">
                                    Ürünleriniz burada listelenmektedir.
                                </p>

                                <table id="datatable-buttons" class="table table-striped table-bordered dt-responsive nowrap">
                                    <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>Başlık</th>
                                        <th>Ürün Kodu</th>
                                        <th>Stok</th>
                                        <th align="center">Durum</th>
                                        <th>İşlem</th>
                                    </tr>
                                    </thead>


                                    <tbody>
                                    <?php

                                    $urunsor=$db->prepare("SELECT * FROM urun order by hit DESC");
                                    $urunsor->execute();

                                    $say=0;
                                    while($urun=$urunsor->fetch(PDO::FETCH_ASSOC)) { $say++;
                                        ?>
                                        <tr>
                                            <td><a href="urun?duzenle=<?php echo $urun['id']; ?>"><?php echo $say; ?></a></td>
                                            <td><a href="urun?duzenle=<?php echo $urun['id']; ?>"><?php echo $urun['baslik']; ?></a></td>
                                            <td><a href="urun?duzenle=<?php echo $urun['id']; ?>"><?php echo $urun['kod']; ?></a></td>
                                            <td><a href="urun?duzenle=<?php echo $urun['id']; ?>"><?php echo $urun['stok']; ?></a></td>
                                            <?php if ($urun['durum']==1) { ?>
                                                <td align="center"><a href="$urun?duzenle=<?php echo $urun['id']; ?>"><span class="badge bg-success">AKTIF</span></a></td>
                                            <?php } else { ?>
                                                <td align="center"><a href="$urun?duzenle=<?php echo $urun['id']; ?>"><span class="badge bg-danger">PASIF</span></a></td>
                                            <?php } ?>
                                            <td align="center"><a href="<?php echo $ayarcek['ayar_url'] . $urun['seo_sef']; ?>"><i class="fas fa-eye"></i></a>   &nbsp;&nbsp;&nbsp; <a href="urun?duzenle=<?php echo $urun['id']; ?>"><i class="fas fa-edit"></i></a>  &nbsp;&nbsp;&nbsp; <a href="urun?sil=<?php echo $urun['id']; ?>"><i class="fas fa-trash"></i></a></td>
                                        </tr>
                                    <?php } ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>
        <?php include 'partials/footer.php'; ?>
    </div>

    <!-- ============================================================== -->
    <!-- End Page content -->
    <!-- ============================================================== -->


</div>
<!-- END wrapper -->

<?php include 'partials/footer-scripts.php'; ?>
<!-- third party js -->
<script src="assets/libs/datatables.net/js/jquery.dataTables.min.js"></script>
<script src="assets/libs/datatables.net-bs5/js/dataTables.bootstrap5.min.js"></script>
<script src="assets/libs/datatables.net-responsive/js/dataTables.responsive.min.js"></script>
<script src="assets/libs/datatables.net-responsive-bs5/js/responsive.bootstrap5.min.js"></script>
<script src="assets/libs/datatables.net-buttons/js/dataTables.buttons.min.js"></script>
<script src="assets/libs/datatables.net-buttons-bs5/js/buttons.bootstrap5.min.js"></script>
<script src="assets/libs/datatables.net-buttons/js/buttons.html5.min.js"></script>
<script src="assets/libs/datatables.net-buttons/js/buttons.flash.min.js"></script>
<script src="assets/libs/datatables.net-buttons/js/buttons.print.min.js"></script>
<script src="assets/libs/datatables.net-keytable/js/dataTables.keyTable.min.js"></script>
<script src="assets/libs/datatables.net-select/js/dataTables.select.min.js"></script>
<script src="assets/libs/pdfmake/build/pdfmake.min.js"></script>
<script src="assets/libs/pdfmake/build/vfs_fonts.js"></script>
<!-- third party js ends -->
<script src="assets/js/pages/datatables.init.js"></script>
<!-- App js-->
<script src="assets/js/app.min.js"></script>


</body>
</html>