<?php

// Veritabanı bağlantısını ayarla (bağlan.php dosyasını kullanabilirsin)
require 'etza/netting/baglan.php';

// Başlık bilgilerini ekle
header("Content-Type: text/xml; charset=utf-8");

// XML yapısını başlat
$xml = new SimpleXMLElement('<?xml version="1.0" encoding="UTF-8"?><urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9"></urlset>');
if ($db->connect_error) {
    die("Veritabanına bağlanırken hata oluştu: " . $db->connect_error);
}
// SEO URL'lerini almak için bir fonksiyon yazıyoruz
function seoUrlEkle($db, $tableName, $seoColumn, $baseUrl, &$xml) {
    // Tablo ve sütun adlarını doğrudan ekliyoruz (bu kısım güvenlik açıklarına dikkat edilmesi gereken yer)
    $sql = "SELECT $seoColumn FROM $tableName";
    
    // Hazırlanmış sorgu çalıştırma
    $stmt = $db->prepare($sql);
    
    // Sorguyu çalıştır
    if ($stmt->execute()) {
        // Sonuçları al
        $results = $stmt->fetchAll(PDO::FETCH_ASSOC);

        // Sonuç varsa, XML'e ekle
        if ($results) {
            foreach ($results as $row) {
                // Her URL için bir <url> elementi ekle
                $url = $xml->addChild('url');
                $url->addChild('loc', $baseUrl . '/' . $row[$seoColumn]);
                $url->addChild('changefreq', 'monthly');
                $url->addChild('priority', '0.8');
            }
        } else {
            echo "$tableName tablosunda sonuç bulunamadı.<br>";
        }
    } else {
        echo "Sorgu çalıştırılamadı: " . $db->errorInfo()[2];
    }
}




// Tablolardan verileri al ve sitemap'e ekle
seoUrlEkle($db, 'odalar', 'seo_sef', 'https://kiralik.kadirhb.net', $xml);
seoUrlEkle($db, 'isletmeler', 'seo_sef', 'https://kiralik.kadirhb.net', $xml);
seoUrlEkle($db, 'blog', 'seo_sef', 'https://kiralik.kadirhb.net', $xml);

// XML dosyasını kaydet
$file = fopen("sitemap.xml", "w");
fwrite($file, $xml->asXML());
fclose($file);

// Başarılı bir şekilde tamamlandığını göster
echo "Sitemap başarıyla oluşturuldu.";

?>
